/*jshint esversion: 6 */

define([
	"lodash", "src/utils", "immutable",
	"src/math/Mat3", "src/math/Vec2", 
	"lib/tasks/dofs",
	"lib/tasks/internal"
	],
function(
	lodash, utils, immutable,
	mat3, vec2, 
	dofs,
	internal
) {

"use strict";

/*============================================================================
	Helpers
============================================================================*/



function dofTransformFromHandle (handle) {
	return new dofs.Transform({ 
		type : handle.getAutoAttribute(),

		x : 0,
		y : 0,
		angle : 0,
		xScale : 1,
		yScale : 1,
		xShear : 0
	});
}


var LayerTransform = {

	init : function (layer) {
		return internal.listInit(layer, dofTransformFromHandle);
	},

	mergeWithMatrix : function (loTransform, loMatrix) {

		loTransform = loTransform.mergeWith(function (tdof, mdof) {

			var mdofAlt = dofs.matrixFromTransform(tdof),
				matAlt = mdofAlt.get("matrix"),
				mat = mdof.get("matrix");

			if (mat3.equalsApproximately(matAlt, mat)) {
				// use transform
				return tdof;
			} else {
				// use matrix
				return dofs.transformFromMatrix(mdof);
			}

																								
		}, loMatrix);

		return loTransform;
	},
/** TODO
	update : function update (layer, totPrev) {

		var lotPrev = totPrev.get("value"),
			tasksNext = layer.tasksNext;

		if (tasksNext.length === 0) {
			var aSum = initChanges(...);

			tasks.forEach(function (task) {
				var lotTask = lotPrev;
				task.update(layer, )
			});
		}



	},

	commit : function commit () {

	}
*/
};

return LayerTransform;

}); // end define


